//
//  AccountListViewController.m
//  ABC Bank
//
//  Created by davesm on 10/14/13.
//  Copyright (c) 2013 Cisco Systems, Inc. All rights reserved.
//

#import "AccountListViewController.h"
#import "AccountListCell.h"
#import "TransactionViewController.h"
#import "TransactionStore.h"
#import "Gradient.h"

@interface AccountListViewController () {
    NSMutableArray * accountList;
    BOOL touchCapture;
}

@end

@implementation AccountListViewController

u_int32_t numberInRange( u_int32_t lower, u_int32_t upper )
{
    return lower + arc4random() % (upper - lower);
}

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super initWithCoder:aDecoder];
    if ( self )
    {
        accountList = [[NSMutableArray alloc] initWithCapacity:3];
        
        NSInteger accountNumber = arc4random();
        
        [accountList addObject:[[TransactionStore alloc] initWithName:@"Savings"
                                                              balance:[NSDecimalNumber decimalNumberWithMantissa:numberInRange( 1000, 10000 ) exponent:0 isNegative:false]
                                                               number:accountNumber
                                                                index:1]];
        [accountList addObject:[[TransactionStore alloc] initWithName:@"Checking"
                                                              balance:[NSDecimalNumber decimalNumberWithMantissa:numberInRange( 500, 5000 ) exponent:0 isNegative:false]
                                                               number:accountNumber
                                                                index:2]];
        [accountList addObject:[[TransactionStore alloc] initWithName:@"Credit Card"
                                                              balance:[NSDecimalNumber decimalNumberWithMantissa:numberInRange( 100, 2000 ) exponent:0 isNegative:false]
                                                               number:accountNumber
                                                                index:3]];
    }
    
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self decorateBackground:self.lowerView];
}

- (void)decorateBackground:(UIView *)view
{
    UIColor * backgroundTop = [UIColor colorWithRed:(CGFloat)0x00 / 0xff green:(CGFloat)0xc6 / 0xff blue:(CGFloat)0x5b / 0xff alpha:1.0f];
    
    UIColor * backgroundBottom = [UIColor colorWithRed:(CGFloat)0x00 / 0xff green:(CGFloat)0x93 / 0xff blue:(CGFloat)0x45 / 0xff alpha:1.0f];
    
    [Gradient applyBackgroundGradient:view
                             topColor:backgroundTop
                          bottomColor:backgroundBottom];
    
}

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    TransactionViewController * tvc = (TransactionViewController*)segue.destinationViewController;
    
    NSIndexPath * selectedPath = self.tableView.indexPathForSelectedRow;
    
    TransactionStore * ts = [accountList objectAtIndex:selectedPath.row];
    
    tvc.store = ts;
}

- (IBAction)callPressed:(id)sender
{
    CJGuestCallViewController * cc = [[CJGuestCallViewController alloc] init];
    
    cc.serverName = [CJGuestCall sharedInstance].serverName;
    cc.toURI = [CJGuestCall sharedInstance].toURI;
    
    cc.delegate = self;
    
    [[self navigationController] pushViewController:cc animated:YES];
}

#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [accountList count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    AccountListCell *cell = [tableView dequeueReusableCellWithIdentifier:@"AccountCell"];
    
    if (!cell) {
        cell = [[AccountListCell alloc] initWithStyle:UITableViewCellStyleDefault
                                      reuseIdentifier:@"AccountCell"];
    }
    
    TransactionStore * ts = [accountList objectAtIndex:[indexPath row]];
    NSNumberFormatter * numberFormatter = [[NSNumberFormatter alloc] init];
    numberFormatter.numberStyle = NSNumberFormatterCurrencyStyle;
    
    cell.accountName.text = ts.name;
    cell.accountNumber.text = ts.accountNumber;
    cell.accountBalance.text = [numberFormatter stringFromNumber:ts.balance];
    
    return cell;
}

#pragma mark CJGuestCallViewControllerDelegate

- (void)callFinishedForCallController:(CJGuestCallViewController *)callController
{
    [self.navigationController popViewControllerAnimated:YES];
}
@end
